unit Star_U;

interface

type
  TStar = class(TObject)
  private
    // Provided code
    fName: String;
    fMagnitude: real;
    fDistance: integer;
    fConstellation: String;
    fNavigationalStatus: Boolean;

  public
    constructor Create(sName: String; rMagnitude: real; iDistance: integer;
      sConstellation: String);
    function getConstellation: String;
    function determineVisibilty: String;
    procedure setNavigationalStatus(bStatus: Boolean);
    function toString: String;
    // Provided code
    function getName: String;
  end;

implementation

Uses Math, SysUtils;
{$R+}

// Provided code
constructor TStar.Create(sName: String; rMagnitude: real; iDistance: integer;
  sConstellation: String);
  begin
    fName := sName;
    fMagnitude := rMagnitude;
    fDistance := iDistance;
    fConstellation := sConstellation;
    fNavigationalStatus := false;
  end;

function TStar.determineVisibilty: String;
  var
    sVisibility: String;
  begin
    if (fDistance < 80) then
      sVisibility := 'Clearly visible'
    else if (fDistance <= 900) then
      if (fMagnitude <= 2) then
        sVisibility := 'Hardly visible to the naked eye'
      else
        sVisibility := 'Only visible by means of standard optical aid'
      else
        sVisibility := 'Only visible by means of specialised optical aid';
    Result := sVisibility;

  end;

function TStar.getConstellation: String;
  begin
    Result := fConstellation;
  end;

function TStar.getName: String;
  begin
    Result := fName;
  end;

procedure TStar.setNavigationalStatus(bStatus: Boolean);
  begin
    fNavigationalStatus := bStatus;
  end;

function TStar.toString: String;
  var
    sOutput: String;
  begin
    sOutput := Format('%s belongs to the' + ' %s constellation.' + #13 + #13 +
        'The star has a magnitude of %3.2f and is %d light years away from Earth.'
        + #13 + #13, [fName, fConstellation, fMagnitude, fDistance]);
    if fNavigationalStatus then
      sOutput := sOutput + fName + ' is a navigational star.'
    else
      sOutput := sOutput + fName + ' is a passive star.';
    Result := sOutput;

  end;

end.
